-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Mar 28, 2025 at 02:03 PM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `arms_db`
--

-- --------------------------------------------------------

--
-- Table structure for table `accommodations`
--

CREATE TABLE `accommodations` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `image_path` varchar(255) NOT NULL,
  `room_type` enum('Duplex','Suite','villa','single','double') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `accommodations`
--

INSERT INTO `accommodations` (`id`, `name`, `description`, `price`, `image_path`, `room_type`) VALUES
(1, 'Duplex22', 'Test data', 10000.00, 'uploads/duplex.jpg', 'Duplex'),
(2, 'Duplex22', 'Test data', 10000.00, 'uploads/duplex.jpg', 'Duplex'),
(3, 'Alex Resort 3 bed room Villa', 'Luxurious Villa located 500m from the cost beach', 35000.00, 'uploads/villa.jpg', 'villa'),
(4, 'Alex Resort 3 bed room Villa', 'Luxurious Villa located 500m from the cost beach', 35000.00, 'uploads/villa.jpg', 'villa'),
(5, 'Villa Rosa', 'Villa Rosa', 25000.00, 'uploads/villa.jpg', 'villa'),
(6, 'Villa Rosa', 'Villa Rosa', 25000.00, 'uploads/villa.jpg', 'villa'),
(7, 'Single bed', 'Nice, elegant ', 2500.00, 'uploads/single.jpg', 'single'),
(8, 'Single bed', 'Nice, elegant ', 2500.00, '../uploads/single.jpg', 'single');

-- --------------------------------------------------------

--
-- Table structure for table `booking`
--

CREATE TABLE `booking` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `email` varchar(255) NOT NULL,
  `check_in` date NOT NULL,
  `check_out` date NOT NULL,
  `status` enum('pending','confirmed','cancelled') DEFAULT 'pending',
  `user_id` int(11) NOT NULL,
  `room_id` int(11) NOT NULL,
  `total_price` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `booking`
--

INSERT INTO `booking` (`id`, `name`, `phone`, `email`, `check_in`, `check_out`, `status`, `user_id`, `room_id`, `total_price`) VALUES
(1, 'Abdihakim Osman', '0745768143', 'hakeemaliosman2@gmail.com', '2025-02-28', '2025-03-01', 'confirmed', 0, 0, 0),
(2, 'Abdihakim Osman', '0745768143', 'abdulhakimalinoor76@gmail.com', '2025-03-02', '2025-03-04', 'confirmed', 0, 0, 0),
(3, 'Abdihakim Osman', '0745768143', 'hakeemaliosman2@gmail.com', '2025-03-02', '2025-03-05', 'confirmed', 0, 0, 0),
(4, 'Hakeem Osman', '0758033114', 'hakeemaliosman2@gmail.com', '2025-03-02', '2025-03-03', 'confirmed', 2, 0, 0),
(5, 'Abdihakim Osman', '0745768143', 'hakeemaliosman2@gmail.com', '2025-03-03', '2025-03-05', 'confirmed', 2, 1, 16000),
(6, 'Hakeem Osman', '0758033114', 'hakeemaliosman2@gmail.com', '2025-03-04', '2025-03-06', 'pending', 2, 2, 10000),
(7, 'Abdihakim Osman', '0745768143', 'hakeemaliosman2@gmail.com', '2025-03-04', '2025-03-06', 'pending', 2, 3, 70000),
(8, 'Abdihakim Osman', '0745768143', 'hakeemaliosman2@gmail.com', '2025-03-04', '2025-03-06', 'confirmed', 2, 5, 50000),
(9, 'Kelvin22', '0745768143', 'kelvin755@gmail.com', '2025-03-20', '2025-03-25', 'confirmed', 7, 4, 175000),
(10, 'Kelvin22', '0745768143', 'kelvin755@gmail.com', '2025-03-28', '2025-03-30', 'confirmed', 7, 2, 20000),
(11, 'Kelvin22', '0745768143', 'kelvin755@gmail.com', '2025-03-07', '2025-03-09', 'confirmed', 7, 7, 5000),
(12, 'Abdihakim Osman', '0745768143', 'hakeemaliosman2@gmail.com', '2025-03-19', '2025-03-20', 'confirmed', 1, 2, 10000),
(13, 'Abdihakim Osman', '0745768143', 'hakeemaliosman2@gmail.com', '2025-03-19', '2025-03-20', 'pending', 1, 5, 25000),
(14, 'Abdihakim Osman', '0745768143', 'hakeemaliosman2@gmail.com', '2025-04-04', '2025-04-05', 'pending', 1, 2, 0),
(15, 'Abdihakim Osman', '0745768143', 'hakeemaliosman2@gmail.com', '2025-03-21', '2025-03-22', 'confirmed', 1, 8, 2500),
(16, 'Abdihakim Osman', '0745768143', 'abdulhakimalinoor76@gmail.com', '2025-04-05', '2025-04-07', 'confirmed', 1, 7, 5000),
(17, 'Abdihakim Osman', '0758033114', 'abdulhakimalinoor76@gmail.com', '2025-04-20', '2025-04-22', 'pending', 1, 4, 70000),
(18, 'Alex Mwangi', '0706065856', 'amwangi25@gmail.com', '2025-04-01', '2025-04-03', 'pending', 9, 7, 5000);

-- --------------------------------------------------------

--
-- Table structure for table `bookings`
--

CREATE TABLE `bookings` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `room_id` int(11) DEFAULT NULL,
  `check_in` date NOT NULL,
  `check_out` date NOT NULL,
  `status` enum('pending','confirmed','checked_in','checked_out','cancelled') NOT NULL DEFAULT 'pending',
  `total_price` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payments`
--

CREATE TABLE `payments` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `booking_id` int(11) NOT NULL,
  `room_id` int(11) NOT NULL,
  `payment_method` enum('Mpesa','Cash') NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment_status` enum('Pending','Completed') DEFAULT 'Pending',
  `transaction_id` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `payments`
--

INSERT INTO `payments` (`id`, `user_id`, `booking_id`, `room_id`, `payment_method`, `amount`, `payment_status`, `transaction_id`, `created_at`) VALUES
(1, 1, 16, 7, 'Mpesa', 5000.00, 'Pending', '0000345', '2025-03-19 14:08:40'),
(2, 1, 16, 7, 'Mpesa', 5000.00, 'Pending', '0000345', '2025-03-19 14:09:46'),
(3, 1, 16, 7, 'Mpesa', 5000.00, 'Completed', '', '2025-03-19 20:43:33'),
(4, 1, 16, 7, 'Mpesa', 5000.00, 'Completed', '', '2025-03-19 20:44:19'),
(5, 1, 16, 7, 'Cash', 5000.00, 'Completed', 'Cash Payment', '2025-03-19 20:53:51'),
(6, 1, 17, 4, 'Mpesa', 70000.00, 'Completed', '', '2025-03-19 21:10:35'),
(7, 9, 18, 7, 'Mpesa', 5000.00, 'Completed', '', '2025-03-19 21:28:09');

-- --------------------------------------------------------

--
-- Table structure for table `rooms`
--

CREATE TABLE `rooms` (
  `id` int(11) NOT NULL,
  `name` varchar(10) NOT NULL,
  `type` enum('single','double','suite','villa') NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `status` enum('available','booked','maintenance') NOT NULL DEFAULT 'available',
  `total_rooms` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `rooms`
--

INSERT INTO `rooms` (`id`, `name`, `type`, `price`, `status`, `total_rooms`) VALUES
(1, 'Duplex', 'single', 8000.00, '', 0),
(2, 'New Room', 'single', 5000.00, 'available', 0);

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `role` enum('admin','staff','guest') NOT NULL DEFAULT 'guest',
  `password_hash` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `role`, `password_hash`, `phone`) VALUES
(1, 'Abdihakim Osman', 'abdulhakimalinoor76@gmail.com', 'guest', '$2y$10$o7qjxKjr1jMaTshlmWPAzOKBL4tfZrVXyEsec7esufskzVGkyZ2lu', ''),
(2, 'Hakeem Osman', 'hakeemaliosman2@gmail.com', 'guest', '$2y$10$3k.KEj.x1sFzOxqUYBhcUuvIJ1XZ0oIsFo9ZxJmXM/u2HmU0ch21C', ''),
(3, 'Peter demesi', 'pdemesi22@gmail.com', 'guest', '', '0745768143'),
(4, 'Admin', 'admin@gmail.com', 'admin', '$2y$10$qBnGWEPlGQX3RXNg4JBMzeS3QgD.ctDteZdiU/X4q6akdGGcKWKtG', ''),
(5, 'Denis Admin', 'admin25@ramco.com', 'admin', '', '0758033114'),
(7, 'Kelvin22', 'kelvin755@gmail.com', 'guest', '$2y$10$tYaXNxRPjjuZNTw5W.0KFOGOvsrX4xTLNVV/SJd53AccyqnbDJdPa', ''),
(8, 'Kevo', 'Kevo22@gmail.com', 'guest', '$2y$10$BlZVIKxtSogOngJIqCNb3OLF/ykobGK1yEZz9.EH45jlMdfrG6zxO', '07111234578'),
(9, 'Alex Mwangi', 'amwangi25@gmail.com', 'guest', '$2y$10$3iOJSFOFlwYHucxoxw1jIOsv9XBOYemOalHn6T23b4T.PWB.83VZW', '0706065856');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `accommodations`
--
ALTER TABLE `accommodations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `booking`
--
ALTER TABLE `booking`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `bookings`
--
ALTER TABLE `bookings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `room_id` (`room_id`);

--
-- Indexes for table `payments`
--
ALTER TABLE `payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `booking_id` (`booking_id`),
  ADD KEY `room_id` (`room_id`);

--
-- Indexes for table `rooms`
--
ALTER TABLE `rooms`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `accommodations`
--
ALTER TABLE `accommodations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `booking`
--
ALTER TABLE `booking`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

--
-- AUTO_INCREMENT for table `bookings`
--
ALTER TABLE `bookings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payments`
--
ALTER TABLE `payments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `rooms`
--
ALTER TABLE `rooms`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `bookings`
--
ALTER TABLE `bookings`
  ADD CONSTRAINT `bookings_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `bookings_ibfk_2` FOREIGN KEY (`room_id`) REFERENCES `rooms` (`id`);

--
-- Constraints for table `payments`
--
ALTER TABLE `payments`
  ADD CONSTRAINT `payments_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `payments_ibfk_2` FOREIGN KEY (`booking_id`) REFERENCES `booking` (`id`),
  ADD CONSTRAINT `payments_ibfk_3` FOREIGN KEY (`room_id`) REFERENCES `accommodations` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
